<?php

if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array (
	'key' => 'group_575fbd5c7235b',
	'title' => esc_html__( 'Map Settings', 'calafate' ),
	'fields' => array (
		array (
			'key' => 'field_575fbd718129a',
			'label' => esc_html__( 'Google maps', 'calafate' ),
			'name' => 'map_enable',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Enable', 'calafate' ),
			'default_value' => 0,
		),
		array (
			'key' => 'field_575fbda38129b',
			'label' => esc_html__( 'Latitude', 'calafate' ),
			'name' => 'map_lat',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
			'readonly' => 0,
			'disabled' => 0,
		),
		array (
			'key' => 'field_575fbdd88129c',
			'label' => esc_html__( 'Longitude', 'calafate' ),
			'name' => 'map_long',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
			'readonly' => 0,
			'disabled' => 0,
		),
		array (
			'key' => 'field_575fbde18129d',
			'label' => esc_html__( 'Info', 'calafate' ),
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => wp_kses( __( 'Use the tool on this website to find your exact map coordinates: <a href="http://www.mapcoordinates.net/en" target="_blank">www.mapcoordinates.net</a>', 'calafate' ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ), // WPCS: XSS OK.
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array (
			'key' => 'field_575fbdfe8129e',
			'label' => esc_html__( 'Marker', 'calafate' ),
			'name' => 'map_marker',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Enable', 'calafate' ),
			'default_value' => 0,
		),
		array (
			'key' => 'field_575fbfa58129f',
			'label' => esc_html__( 'Marker image', 'calafate' ),
			'name' => 'map_marker_img',
			'type' => 'image',
			'instructions' => esc_html__( 'Image should be a 240 x 240px transparent png file.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array (
			'key' => 'field_575fc085812a0',
			'label' => esc_html__( 'Zoom level', 'calafate' ),
			'name' => 'map_zoom',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'default_value' => 16,
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'min' => 1,
			'max' => 20,
			'step' => 1,
			'readonly' => 0,
			'disabled' => 0,
		),
		array (
			'key' => 'field_575fc743bacae',
			'label' => esc_html__( 'Style', 'calafate' ),
			'name' => 'map_style',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'Regular' => 'Regular',
				'Greyscale' => 'Greyscale',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'vertical',
			'allow_null' => 0,
		),
		array (
			'key' => 'field_575fbd7181295',
			'label' => esc_html__( 'Google API Key', 'calafate' ),
			'name' => 'gmaps_key',
			'type' => 'text',
			'instructions' => wp_kses( __( 'Since Google Maps changed their API to version 3, all the embedded maps need an API key in order to run. Maps on old sites will still work, but new ones don\'t. <br><br>If this is the case for you, <a href="https://developers.google.com/maps/documentation/javascript/get-api-key#key" target="_blank">read this article</a> or <a href="https://www.youtube.com/watch?v=OH98za14LNg" target="_blank">watch this video</a> (up until 2:00) to learn how to obtain a proper API key.', 'calafate' ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ), // WPCS: XSS OK.
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			)
		)
	),
	'location' => array (
		array (
			array (
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'template-contact.php',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_575fbd5s7235b',
	'title' => esc_html__( 'Social Sharing Settings', 'calafate' ),
	'fields' => array (
		array (
			'key' => 'field_575fbda38122d',
			'label' => esc_html__( 'Disable theme sharing tools', 'calafate' ),
			'name' => 'calafate_sharing_disable',
			'type' => 'true_false',
			'message' => esc_html__( 'Disable please!', 'calafate' ),
			'instructions' => esc_html__( 'By default, the theme inserts some meta tags in the header of your website in order to facilitate social sharing. If you are using a SEO plugin which already does this, you might want to disable the theme functions in order to prevent any conflicts.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
			'readonly' => 0,
			'disabled' => 0,
		)
	),
	'location' => array (
		array (
			array (
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-theme-tools',
			),
		),
	),
	'menu_order' => 1,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_575fbd5c7232a',
	'title' => esc_html__( 'Custom CSS Code', 'calafate' ),
	'fields' => array (
		array (
			'key' => 'field_575fbd7518125a',
			'label' => esc_html__( 'Code', 'calafate' ),
			'name' => 'calafate_custom_css',
			'type' => 'textarea',
			'instructions' => esc_html__( 'This is a basic textarea to insert your own custom CSS code at the head of the theme. If you are planning to do serious modifications to the theme, please use the provided child theme for this purpose.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-theme-tools',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));



acf_add_local_field_group(array (
	'key' => 'group_572bbd5c7232a',
	'title' => esc_html__( 'Feature post', 'calafate' ),
	'fields' => array (
		array (
			'key' => 'field_575f2d93bacae',
			'label' => esc_html__( 'Feature level', 'calafate' ),
			'instructions' => esc_html__( 'Only affects the display in the post creative grid.', 'calafate' ),
			'name' => 'post_feature',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 100,
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'1' => esc_html__( 'Don\'t feature', 'calafate' ),
				'2' => esc_html__( 'Larger thumbnail', 'calafate' ),
				'3' => esc_html__( 'Even larger thumbnail', 'calafate' ),
				'banner' => esc_html__( 'Huge banner', 'calafate' )
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '1',
			'layout' => 'vertical',
			'allow_null' => 0,
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
	),
	'menu_order' => 99,
	'position' => 'side',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_5729aebecfc8c',
	'title' => esc_html__( 'Unique Project Settings', 'calafate' ),
	'fields' => array (
		array (
			'key' => 'field_5729aee56851e',
			'label' => esc_html__( 'Flexible size', 'calafate' ),
			'name' => 'project-size',
			'type' => 'radio',
			'instructions' => esc_html__( 'If you are using a flexible masonry grid you have the option to break the original column size with each project, thus creating a stunning grid. Use this field to multiply the original column in your portfolio grid. eg: You have a 6 columns grid and you want this project to fill half the grid. You will choose size 3. If you want it to fill the entire grid, you choose 6.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				1 => '<span class="ups ups-1">' . esc_html__( '1 column', 'calafate' ) . '</span>',
				2 => '<span class="ups ups-2">' . esc_html__( '2 columns', 'calafate' ) . '</span>',
				3 => '<span class="ups ups-3">' . esc_html__( '3 columns', 'calafate' ) . '</span>',
				4 => '<span class="ups ups-4">' . esc_html__( '4 columns', 'calafate' ) . '</span>',
				5 => '<span class="ups ups-5">' . esc_html__( '5 columns', 'calafate' ) . '</span>',
				6 => '<span class="ups ups-6">' . esc_html__( '6 columns', 'calafate' ) . '</span>',
			),
			'default_value' => array (
				1 => '<span class="ups ups-1">' . esc_html__( '1 column', 'calafate' ) . '</span>'
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'disabled' => 0,
			'readonly' => 0,
		),
		array (
			'key' => 'field_572b315a486b3',
			'label' => esc_html__( 'Unique portfolio page', 'calafate' ),
			'name' => 'portfolio-unique',
			'type' => 'post_object',
			'instructions' => esc_html__( 'If you\'re using multiple portfolios, please choose the portfolio page where this project is included.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array (
				0 => 'page',
			),
			'taxonomy' => array (
			),
			'allow_null' => 1,
			'multiple' => 0,
			'return_format' => 'id',
			'ui' => 1,
		),
		array (
			'key' => 'field_572ba95a486b3',
			'label' => esc_html__( 'Lightbox / url alternative', 'calafate' ),
			'name' => 'portfolio-lightbox-message',
			'type' => 'message',
			'instructions' => esc_html__( 'You have the possibility to make this project load a certain element (image or video) inside a lightbox on the grid, and totally skip the loading of the actual project page. Or, you can skip the lightbox and just open a url of your choice in the same window.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
			'readonly' => 0,
			'disabled' => 0
		),
		array (
			'key' => 'field_57190z95a486b3',
			'label' => esc_html__( 'Type', 'calafate' ),
			'name' => 'portfolio-lightbox-type',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'choices' => array (
				'none' => 'None',
				'img' => 'Image',
				'iframe' => 'Iframe',
				'url' => 'Url (no lightbox)'
			),
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 'none',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
			'readonly' => 0,
			'disabled' => 0
		),
		array (
			'key' => 'field_572opQ5a486b3',
			'label' => esc_html__( 'URL', 'calafate' ),
			'name' => 'portfolio-lightbox-url',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
			'readonly' => 0,
			'disabled' => 0
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'portfolio',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_5729aebecqc8c',
	'title' => esc_html__( 'Unique Product Settings', 'calafate' ),
	'fields' => array (
		array (
			'key' => 'field_57f9aee56851e',
			'label' => esc_html__( 'Flexible size', 'calafate' ),
			'name' => 'project-size',
			'type' => 'radio',
			'instructions' => esc_html__( 'If you are using a flexible masonry grid you have the option to break the original column size with each product, thus creating a stunning grid. Use this field to multiply the original column in your shop grid. eg: You have a 6 columns grid and you want this product to fill half the grid. You will choose size 3. If you want it to fill the entire grid, you choose 6.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				1 => '<span class="ups ups-1">' . esc_html__( '1 column', 'calafate' ) . '</span>',
				2 => '<span class="ups ups-2">' . esc_html__( '2 columns', 'calafate' ) . '</span>',
				3 => '<span class="ups ups-3">' . esc_html__( '3 columns', 'calafate' ) . '</span>',
				4 => '<span class="ups ups-4">' . esc_html__( '4 columns', 'calafate' ) . '</span>',
				5 => '<span class="ups ups-5">' . esc_html__( '5 columns', 'calafate' ) . '</span>',
				6 => '<span class="ups ups-6">' . esc_html__( '6 columns', 'calafate' ) . '</span>',
			),
			'default_value' => array (
				1 => '<span class="ups ups-1">' . esc_html__( '1 column', 'calafate' ) . '</span>'
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'disabled' => 0,
			'readonly' => 0,
		),
		array (
			'key' => 'field_57d1qqe93ee426',
			'label' => esc_html__( 'Product gallery tweaks', 'calafate' ),
			'name' => 'project-hide-img',
			'type' => 'checkbox',
			'instructions' => esc_html__( 'If you want to tweak the product gallery (left side) in order to completely disable it and only show the hero header, or to hide the featured image from the gallery, leaving only the other images.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'hide' => esc_html__( 'Hide gallery entirely', 'calafate' ),
				'hide-featured' => esc_html__( 'Hide only featured image', 'calafate' )
			)
		)
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'product',
			),
		),
	),
	'menu_order' => 2,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_57289e82e0461',
	'title' => esc_html__( 'Portfolio Settings', 'calafate' ),
	'fields' => array (
		array (
			'key' => 'field_57299a90be7f5',
			'label' => esc_html__( 'Portfolio configuration', 'calafate' ),
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Edit this portfolio page\'s content and behaviour.', 'calafate' ),
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array (
			'key' => 'field_57289e93ee426',
			'label' => esc_html__( 'Displayed categories', 'calafate' ),
			'name' => 'portfolio-categories',
			'type' => 'taxonomy',
			'instructions' => esc_html__( 'Choose which of the portfolio categories you want to include.', 'calafate' ),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'taxonomy' => 'portfolio_category',
			'field_type' => 'checkbox',
			'allow_null' => 0,
			'add_term' => 0,
			'save_terms' => 0,
			'load_terms' => 0,
			'return_format' => 'id',
			'multiple' => 0,
		),
		array (
			'key' => 'field_5728a276dc11c',
			'label' => esc_html__( 'Projects per page', 'calafate' ),
			'name' => 'portfolio-page',
			'type' => 'number',
			'instructions' => esc_html__( 'Use "-1" if you want to display all of your projects on the page. Lazy loading will still be used anyway.', 'calafate' ),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => -1,
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'min' => -1,
			'max' => 32,
			'step' => 1,
			'readonly' => 0,
			'disabled' => 0,
		),
		array (
			'key' => 'field_573d2a96b8ba0',
			'label' => esc_html__( 'Extra content', 'calafate' ),
			'name' => 'portfolio-extra',
			'type' => 'select',
			'instructions' => esc_html__( 'Display page builder content', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'0' => esc_html__( 'Don\'t display', 'calafate'),
				'1' => esc_html__( 'Below the grid', 'calafate'),
				'2' => esc_html__( 'Above the grid', 'calafate'),
			),
			'message' => '',
			'default_value' => 0,
		),
		array (
			'key' => 'field_5728a2a5dc11d',
			'label' => esc_html__( 'Portfolio style', 'calafate' ),
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Edit this portfolio page\'s style.', 'calafate' ),
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array (
			'key' => 'field_5729a9e2b7e2c',
			'label' => esc_html__( 'Masonry grid type', 'calafate' ),
			'name' => 'portfolio-type',
			'type' => 'select',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'Flexible' => esc_html__( 'Flexible', 'calafate'),
				'Fixed' => esc_html__( 'Fixed', 'calafate'),
				'Regular' => esc_html__( 'Regular', 'calafate'),
			),
			'default_value' => array (
				0 => 'Flexible',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'disabled' => 0,
			'readonly' => 0,
		),
		array (
			'key' => 'field_5729aa22b7e2d',
			'label' => esc_html__( 'Regular grid aspect ratio', 'calafate' ),
			'name' => 'portfolio-aspect-ratio',
			'type' => 'select',
			'instructions' => esc_html__( 'All items displayed in the regular grid will have the exact same size, so you need to specify the desired aspect ratio for the resizing function.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_5729a9e2b7e2c',
						'operator' => '==',
						'value' => 'Regular',
					),
				),
			),
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'4:3' => '4:3',
				'16:9' => '16:9',
				'3:4' => '3:4',
				'1:1' => '1:1',
			),
			'default_value' => array (
				0 => '4:3',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'disabled' => 0,
			'readonly' => 0,
		),
		array (
			'key' => 'field_57299903fa1c8',
			'label' => esc_html__( 'Number of columns', 'calafate' ),
			'name' => 'portfolio-columns',
			'type' => 'select',
			'instructions' => esc_html__( 'Default number of columns in the grid, which can be overwritten by individual projects.', 'calafate' ),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				1 => 1,
				2 => 2,
				3 => 3,
				4 => 4,
				5 => 5,
				6 => 6,
			),
			'default_value' => array (
				3 => 3,
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'disabled' => 0,
			'readonly' => 0,
		),
		array (
			'key' => 'field_57299a4f4b89b',
			'label' => esc_html__( 'Columns gap', 'calafate' ),
			'name' => 'portfolio-gap',
			'type' => 'number',
			'instructions' => esc_html__( 'Default margin between each element in the grid.', 'calafate' ),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'default_value' => 10,
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'min' => 0,
			'max' => 100,
			'step' => 1,
			'readonly' => 0,
			'disabled' => 0,
		),
		array (
			'key' => 'field_5728a10ba8116',
			'label' => esc_html__( 'Desktop caption animation', 'calafate' ),
			'name' => 'portfolio-style',
			'type' => 'select',
			'instructions' => esc_html__( 'Targets screens with a resolution larger than 1024px.', 'calafate' ),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'Minimal' => esc_html__( 'Minimal', 'calafate' ),
				'Classic' => esc_html__( 'Classic', 'calafate' ),
				'hover-two' => esc_html__( 'None (always shown)', 'calafate' ),
				'huge' => esc_html__( 'Huge overlay', 'calafate' )
			),
			'default_value' => array (
				0 => 'Minimal lines',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'disabled' => 0,
			'readonly' => 0,
		),
		array (
			'key' => 'field_5728aqzra8116',
			'label' => esc_html__( 'Mobile caption behaviour', 'calafate' ),
			'name' => 'portfolio-caption',
			'type' => 'select',
			'instructions' => esc_html__( 'Targets mobile touch devices with a resolution lower than 1024px.', 'calafate' ),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'none' => esc_html__( 'Don\'t show animation', 'calafate' ),
				'tap' => esc_html__( 'First tap displays animation', 'calafate' ),
				'always' => esc_html__( 'Always show caption', 'calafate' )
			),
			'default_value' => array (
				0 => 'Minimal lines',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'disabled' => 0,
			'readonly' => 0,
		),
		array (
			'key' => 'field_57299b70e242c',
			'label' => esc_html__( 'Caption background color', 'calafate' ),
			'name' => 'portfolio-style-background',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 33,
				'class' => '',
				'id' => '',
			),
			'default_value' => '#ffffff',
		),
		array (
			'key' => 'field_57299b88e242d',
			'label' => esc_html__( 'Caption background opacity', 'calafate' ),
			'name' => 'portfolio-style-opacity',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 33,
				'class' => '',
				'id' => '',
			),
			'default_value' => 100,
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'min' => 0,
			'max' => 100,
			'step' => 1,
			'readonly' => 0,
			'disabled' => 0,
		),
		array (
			'key' => 'field_57299bbdd7825',
			'label' => esc_html__( 'Caption text color', 'calafate' ),
			'name' => 'portfolio-style-text',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 33,
				'class' => '',
				'id' => '',
			),
			'default_value' => '#000000',
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'template-portfolio.php',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_5728563d5fa70',
	'title' => esc_html__( 'Page Style', 'calafate' ),
	'fields' => array (
		array (
			'key' => 'field_573d6a96b8ba0',
			'label' => esc_html__( 'Color scheme', 'calafate' ),
			'name' => 'page-scheme',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Use unique different color scheme for this page', 'calafate' ),
			'default_value' => 0,
		),
		array (
			'key' => 'field_5728566adc858',
			'label' => esc_html__( 'Background color', 'calafate' ),
			'name' => 'page-bg-color',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_573d6a96b8ba0',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array (
				'width' => 33,
				'class' => '',
				'id' => '',
			),
			'default_value' => '#000000',
		),
		array (
			'key' => 'field_5728568adc859',
			'label' => esc_html__( 'Text color', 'calafate' ),
			'name' => 'page-txt-color',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_573d6a96b8ba0',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array (
				'width' => 33,
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array (
			'key' => 'field_573d6acab8ba1',
			'label' => esc_html__( 'Accent color', 'calafate' ),
			'name' => 'page-acc-color',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_573d6a96b8ba0',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array (
				'width' => 33,
				'class' => '',
				'id' => '',
			),
			'default_value' => '#0ff1b3',
		),
		array (
			'key' => 'field_5728de3dc85a',
			'label' => esc_html__( 'Background color visibility', 'calafate' ),
			'name' => 'page-bg-opacity-s',
			'type' => 'number',
			'instructions' => esc_html__( 'The page background\'s color visibility before scrolling.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'default_value' => 0,
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'min' => 0,
			'max' => 100,
			'step' => 1,
			'readonly' => 0,
			'disabled' => 0,
		),
		array (
			'key' => 'field_572856c3dc85a',
			'label' => esc_html__( 'Background color visibility (end)', 'calafate' ),
			'name' => 'page-bg-opacity',
			'type' => 'number',
			'instructions' => esc_html__( 'The page background\'s color visiblity after scrolling.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'default_value' => 90,
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'min' => 0,
			'max' => 100,
			'step' => 1,
			'readonly' => 0,
			'disabled' => 0,
		),
		array (
			'key' => 'field_573c54993fb52',
			'label' => esc_html__( 'Custom logo', 'calafate' ),
			'name' => 'page-logo',
			'type' => 'image',
			'instructions' => esc_html__( 'Optional image logo for this page (if you\'re using image logo). Please make sure that the custom logo is exactly the same size as the original one!', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'page_type',
				'operator' => '!=',
				'value' => 'posts_page',
			),
		),
	),
	'menu_order' => 1,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_5728534ca41aa',
	'title' => esc_html__( 'Hero Header', 'calafate' ),
	'fields' => array (
		array (
			'key' => 'field_57285d2f0133c',
			'label' => esc_html__( 'Hero header', 'calafate' ),
			'name' => 'hero-enabled',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Enable the fullscreen fixed hero header', 'calafate' ),
			'default_value' => 0,
		),
		array (
			'key' => 'field_572854b235171',
			'label' => esc_html__( 'Image(s)', 'calafate' ),
			'name' => 'hero-gallery',
			'type' => 'gallery',
			'instructions' => esc_html__( 'Upload one or more images for the hero header (multiple images are placed in a slider).', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'array',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array (
			'key' => 'field_572855s823746c',
			'label' => esc_html__( 'Slider autoplay', 'calafate' ),
			'name' => 'hero-gallery-autoplay',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Enable', 'calafate' ),
			'default_value' => 0,
		),
		array (
			'key' => 'field_5w3f55823746c',
			'label' => esc_html__( 'Slider captions', 'calafate' ),
			'name' => 'hero-gallery-captions',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Enable', 'calafate' ),
			'default_value' => 0,
		),
		array (
			'key' => 'field_572854def6b3d',
			'label' => esc_html__( 'Video', 'calafate' ),
			'name' => 'hero-video',
			'type' => 'file',
			'instructions' => esc_html__( 'If present, it will be used instead of the image(s). However, mobile devices will still show a static image, so you should upload one image as a fallback, whenever the video will fail to load.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'library' => 'all',
			'min_size' => '',
			'max_size' => '',
			'mime_types' => 'mp4',
		),
		array (
			'key' => 'field_5728558f6746c',
			'label' => esc_html__( 'Video loop', 'calafate' ),
			'name' => 'hero-video-loop',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Enable', 'calafate' ),
			'default_value' => 1,
		),
		array (
			'key' => 'field_573c5b6cfbe57',
			'label' => esc_html__( 'Custom tagline', 'calafate' ),
			'name' => 'hero-tagline',
			'type' => 'wysiwyg',
			'instructions' => esc_html__( 'Replaces the default title of the portfolio item / page.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'tabs' => 'all',
			'toolbar' => 'full',
			'media_upload' => 0,
		),
		array (
			'key' => 'field_5728553fl746c',
			'label' => esc_html__( 'No text', 'calafate' ),
			'name' => 'hero-hide-text',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Completely hide title / tagline on hero header', 'calafate' ),
			'default_value' => 0,
		),
		array (
			'key' => 'field_57285535l746c',
			'label' => esc_html__( 'Vertical centering', 'calafate' ),
			'name' => 'hero-vertical-text',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Center the tagline vertically on the hero header', 'calafate' ),
			'default_value' => 0,
		),
		array (
			'key' => 'field_57285532d746c',
			'label' => esc_html__( 'No page title', 'calafate' ),
			'name' => 'hero-hide-title',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Hide the page title even when there is no hero header', 'calafate' ),
			'default_value' => 0,
		),
		array (
			'key' => 'field_572855e1d746c',
			'label' => esc_html__( 'Reduce hero height (hides tagline)', 'calafate' ),
			'name' => 'hero-reduce-gap',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Reduce the gap between the header and the main content when the hero header is enabled', 'calafate' ),
			'default_value' => 0,
		),
		array (
			'key' => 'field_5729910fe242d',
			'label' => esc_html__( 'Content visibility', 'calafate' ),
			'name' => 'hero-gap-length',
			'type' => 'number',
			'instructions' => 'Percentage (how much of the content is visible before scroll)',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => 50,
				'class' => '',
				'id' => '',
			),
			'default_value' => 100,
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'min' => 0,
			'max' => 100,
			'step' => 5,
			'readonly' => 0,
			'disabled' => 0,
		),
		array (
			'key' => 'field_5722dqe1d746c',
			'label' => esc_html__( 'Scroll hero header', 'calafate' ),
			'name' => 'hero-stick-it',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Transform the fixed hero header into a regular hero which scrolls along with the content.', 'calafate' ),
			'default_value' => 0,
		)
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '!=',
				'value' => 'post',
			),
			array (
				'param' => 'page_type',
				'operator' => '!=',
				'value' => 'posts_page',
			),
		),
	),
	'menu_order' => 2,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_57285ss34ca41aa',
	'title' => esc_html__( 'Hero Header', 'calafate' ),
	'fields' => array (
		array (
			'key' => 'field_57285d2f0133c',
			'label' => esc_html__( 'Hero header', 'calafate' ),
			'name' => 'hero-enabled',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Enable the fullscreen fixed hero header', 'calafate' ),
			'default_value' => 0,
		),
		array (
			'key' => 'field_572854b235171',
			'label' => esc_html__( 'Image(s)', 'calafate' ),
			'name' => 'hero-gallery',
			'type' => 'gallery',
			'instructions' => esc_html__( 'Upload one or more images for the hero header (multiple images are placed in a slider).', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'array',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array (
			'key' => 'field_572855823746c',
			'label' => esc_html__( 'Slider autoplay', 'calafate' ),
			'name' => 'hero-gallery-autoplay',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Enable', 'calafate' ),
			'default_value' => 0,
		),
		array (
			'key' => 'field_5728f1def6b3d',
			'label' => esc_html__( 'Video', 'calafate' ),
			'name' => 'hero-video',
			'type' => 'file',
			'instructions' => esc_html__( 'If present, it will be used instead of the image(s). However, mobile devices will still show a static image, so you should upload one image as a fallback, whenever the video will fail to load.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'library' => 'all',
			'min_size' => '',
			'max_size' => '',
			'mime_types' => 'mp4',
		),
		array (
			'key' => 'field_5728558f6746c',
			'label' => esc_html__( 'Video loop', 'calafate' ),
			'name' => 'hero-video-loop',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Enable', 'calafate' ),
			'default_value' => 1,
		),
		array (
			'key' => 'field_5722dqe1d746c',
			'label' => esc_html__( 'Scroll hero header', 'calafate' ),
			'name' => 'hero-stick-it',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => esc_html__( 'Transform the fixed hero header into a regular hero which scrolls along with the content.', 'calafate' ),
			'default_value' => 0,
		)
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			)
		),
	),
	'menu_order' => 2,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));


acf_add_local_field_group(array (
	'key' => 'group_59032aefqc2d9',
	'title' => 'Featured links',
	'fields' => array (
	/*	array (
			'key' => 'field_590337406d054',
			'label' => 'Link list',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),*/
		array (
			'key' => 'field_59032b2qx6dd2',
			'label' => 'Items',
			'name' => 'item',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => '',
			'min' => 0,
			'max' => 0,
			'layout' => 'table',
			'button_label' => '',
			'sub_fields' => array (
				array (
					'key' => 'field_59032qxfb6dd3',
					'label' => 'Title',
					'name' => 'title',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array (
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array (
					'key' => 'field_59032qx5b6dd4',
					'label' => 'Image',
					'name' => 'image',
					'type' => 'image',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array (
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'url',
					'preview_size' => 'shop_thumbnail',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
				),
				array (
					'key' => 'field_59032qx5b6dd5',
					'label' => 'URL',
					'name' => 'url',
					'type' => 'url',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array (
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
				),
				array (
					'key' => 'field_590qx2d1b6dd5',
					'label' => 'Target',
					'name' => 'target',
					'type' => 'checkbox',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array (
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array (
						'_blank' => esc_html__( 'Open in new window', 'calafate' )
					),
					'placeholder' => '',
				),
			),
		),
		array (
			'key' => 'field_590337qx6d053',
			'label' => 'Call to action',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array (
			'key' => 'field_5903qx4e6d055',
			'label' => 'Label',
			'name' => 'cta_label',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array (
			'key' => 'field_5903qx5c6d056',
			'label' => 'URL',
			'name' => 'cta_url',
			'type' => 'url',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
		)/*,
		array (
			'key' => 'field_5903qp386d053',
			'label' => 'Initial background',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array (
			'key' => 'field_5752cfa58129f',
			'label' => esc_html__( 'Image', 'calafate' ),
			'name' => 'cover_bg',
			'type' => 'image',
			'instructions' => esc_html__( 'An optional cover image for the entire page.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array (
			'key' => 'field_5723t4def6b3d',
			'label' => esc_html__( 'Video', 'calafate' ),
			'name' => 'cover_video',
			'type' => 'file',
			'instructions' => esc_html__( 'An optional cover video for the entire page.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'library' => 'all',
			'min_size' => '',
			'max_size' => '',
			'mime_types' => 'mp4',
		),*/
	),
	'location' => array (
		array (
			array (
				'param' => 'post_template',
				'operator' => '==',
				'value' => 'template-cover-alternate.php',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_59032aefbf2d9',
	'title' => 'Featured links',
	'fields' => array (
	/*	array (
			'key' => 'field_590337406d054',
			'label' => 'Link list',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),*/
		array (
			'key' => 'field_59032b14b6dd0',
			'label' => 'Title',
			'name' => 'title',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array (
			'key' => 'field_59032b8db6dd7',
			'label' => 'Style',
			'name' => 'style',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'Full width' => 'Full width',
				'Split screen' => 'Split screen',
			),
			'default_value' => array (
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array (
			'key' => 'field_59032b2ab6dd2',
			'label' => 'Items',
			'name' => 'item',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => '',
			'min' => 0,
			'max' => 0,
			'layout' => 'table',
			'button_label' => '',
			'sub_fields' => array (
				array (
					'key' => 'field_59032b3fb6dd3',
					'label' => 'Title',
					'name' => 'title',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array (
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array (
					'key' => 'field_59032b45b6dd4',
					'label' => 'Image',
					'name' => 'image',
					'type' => 'image',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array (
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'url',
					'preview_size' => 'shop_thumbnail',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
				),
				array (
					'key' => 'field_59032b55b6dd5',
					'label' => 'URL',
					'name' => 'url',
					'type' => 'url',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array (
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
				),
				array (
					'key' => 'field_590312d1b6dd5',
					'label' => 'Target',
					'name' => 'target',
					'type' => 'checkbox',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array (
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array (
						'_blank' => esc_html__( 'Open in new window', 'calafate' )
					),
					'placeholder' => '',
				),
			),
		),
		array (
			'key' => 'field_093uer023j1qd',
			'label' => 'Mobile links behaviour',
			'name' => 'mobile',
			'type' => 'checkbox',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'taponce' => esc_html__( 'Tap only once to open link', 'calafate' )
			),
			'placeholder' => ''
		),
		array (
			'key' => 'field_590337186d053',
			'label' => 'Call to action',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array (
			'key' => 'field_5903374e6d055',
			'label' => 'Label',
			'name' => 'cta_label',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array (
			'key' => 'field_5903375c6d056',
			'label' => 'URL',
			'name' => 'cta_url',
			'type' => 'url',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
		),
		array (
			'key' => 'field_5903qp386d053',
			'label' => 'Initial background',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array (
			'key' => 'field_5752cfa58129f',
			'label' => esc_html__( 'Image', 'calafate' ),
			'name' => 'cover_bg',
			'type' => 'image',
			'instructions' => esc_html__( 'An optional cover image for the entire page.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array (
			'key' => 'field_5723t4def6b3d',
			'label' => esc_html__( 'Video', 'calafate' ),
			'name' => 'cover_video',
			'type' => 'file',
			'instructions' => esc_html__( 'An optional cover video for the entire page.', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'library' => 'all',
			'min_size' => '',
			'max_size' => '',
			'mime_types' => 'mp4',
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'post_template',
				'operator' => '==',
				'value' => 'template-cover.php',
			),
		)
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));


acf_add_local_field_group(array(
	'key' => 'group_5bb62b54s2dee6',
	'title' => 'Disable Gutenberg Editor',
	'fields' => array(
		array(
		'key' => 'field_5bffacf21a1c2fa',
		'label' => '',
		'name' => '',
		'type' => 'message',
		'instructions' => '',
		'required' => 0,
		'wrapper' => array(
			'width' => '',
			'class' => '',
			'id' => '',
		),
		'message' => esc_html__( 'Calafate has it\'s own content editor, which works very easy and is custom tailored for the theme. If you wish however to disable it and use the new Gutenberg editor instead, you can do so.', 'calafate' ),
		'new_lines' => 'wpautop',
		'esc_html' => 0,
		'default_value' => 0,
		),
		array (
			'key' => 'field_5ccmqa9d1b6dd5',
			'label' => esc_html__( 'Enable Gutenberg', 'calafate' ),
			'name' => 'enable_gutenberg',
			'type' => 'checkbox',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'enable' => esc_html__( 'Enable', 'calafate' )
			),
			'placeholder' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-content-editor',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5bb62b542dee6',
	'title' => 'test',
	'fields' => array(
		array(
			'key' => 'field_5bb62b572be7a',
			'label' => esc_html__( 'Slide URL', 'calafate' ),
			'name' => 'calafate_hero_extra_url',
			'type' => 'text',
			'instructions' => esc_html__( 'Only for sliders (caption required)', 'calafate' ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'attachment',
				'operator' => '==',
				'value' => 'image',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));


endif;


if ( function_exists('acf_add_options_sub_page') ) :

	acf_add_options_sub_page(array(
		'page_title' 	=> esc_html__( 'Content Editor', 'calafate' ),
		'menu_title' 	=> esc_html__( 'Content Editor', 'calafate' ),
		'parent_slug' 	=> 'options-general.php',
	));

endif;